/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validators.NewLoginValidator.java
 * Desprition : This Validators class is responsible for checking and validating the 
 * Customer's password during Registration .
 * 
 */
package Validators;


import JavaBeans.* ;
/**
 * @author student
 *
 * This class is being used for validation of a given password with the 
 * verifier.
 * 
 */
public class NewLoginValidator {
	
	private String message;
	
	/**
	 * This method is being used for getting an error message if the
	 * validation was unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage(){
		return message;
	}
	
	/**
	 * This method is being used for setting an error message if the
	 * validation is unsuccessful.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message){
		this.message = message;
	}
	
	
	/**
	 * This method is being used for validation of the password and
	 * verifier.
	 * @param customerData The customer data to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(Customer_Data customerData){
		
		Customer_Data customerdata = customerData;
		String password ,verifier;
		password = customerdata.getPassword();
		verifier = customerdata.getVerifier();
		
		//check verifier and password.
		if(verifier == null||password ==null){
			message = "Either password or verify password field is empty.";
			return false;
		}
		else if(!verifier.equals(password)){
			message = "The given password does not match the verifying password.";
			return false;
		}
		if(!password.matches("^[a-zA-Z/`/'/s/ ]{4,30}+$")){
			message = "Password has some invalid characters.";
			message += " Password has to be between 4 and 30 characters long. ";
			
			return false;
		}
		return true;
			
	}
}
